/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWRosterElement;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminElementTableData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWParticipantItem;

public class VWAdminRosterElementTableData
extends VWAdminElementTableData {
    public VWAdminRosterElementTableData(VWRosterElement element, VWParticipant logonUser, int displayRowIndex, int rowIndex) {
        super(logonUser, displayRowIndex, rowIndex);
        try {
            this.m_element = element;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object getElement() {
        return (VWRosterElement)this.m_element;
    }

    protected VWWorkObject getWob() {
        VWWorkObject wob = null;
        boolean lock = false;
        boolean override = false;
        if (this.m_element != null) {
            try {
                wob = ((VWRosterElement)this.m_element).fetchWorkObject(lock, override);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return wob;
    }

    protected String getLockedUser() {
        String user = null;
        VWWorkObject wob = this.getWob();
        if (wob != null) {
            try {
                VWParticipantItem vwParticipantItem = new VWParticipantItem(((VWQueueElement)this.m_element).getLockedUserPx());
                user = vwParticipantItem.getDisplayName();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return user;
    }

    protected int getLockedStatus() {
        int stat = -1;
        if (this.m_logonUser == null) {
            return stat;
        }
        VWWorkObject wob = this.getWob();
        if (wob != null) {
            try {
                int lockedStatus = wob.fetchLockedStatus();
                if (lockedStatus == 2) {
                    return 0;
                }
                if (lockedStatus == 0) {
                    return 3;
                }
                VWParticipant lockedUser = wob.getLockedUserPx();
                if (lockedUser != null) {
                    if (VWStringUtils.compareUsers(lockedUser.getParticipantName(), this.m_logonUser.getParticipantName())) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return stat;
    }
}

